unit mVimmSelect;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, System.UITypes, VCL.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, mVimmBase, Vcl.StdCtrls, Vcl.ExtCtrls, mVimmEdit, ORCtrls, ORFn, rVimm,
  Vcl.ImgList, Vcl.Buttons, System.ImageList;

type
  TfraImm = class(TfraParent)
    rgpDocumentation: TRadioGroup;
    lblImm: TLabel;
    cboImm: TORComboBox;
    gridPanel: TGridPanel;
    pnlImm: TPanel;

    procedure rgpDocumentationClick(Sender: TObject);
    procedure cboImmClick(Sender: TObject);
    procedure rgpDocumentationEnter(Sender: TObject);
    procedure btnExpandCollapseClick(Sender: TObject);
  private
    { Private declarations }
    adminDate: TFMDateTime;
    patientIEN: string;
    procedure selectPage(immunization: string; details, edit: boolean);
    function getEditControl: TControl;
    function performCheck(immunization, patient: string): integer;
  protected
    isEditing: boolean;
  public
    { Public declarations }
    constructor Create(aOwner: TComponent); override;
    procedure startEdits(immunization: string = ''; details: boolean = false; edit: boolean = true);
    function startEditsFromMain(immunization: string; edit: boolean): boolean;
    function setEditFields(immunization: string): boolean;
    procedure collapse;
    procedure expand;
    procedure disableImmLookup;
    procedure clearFields;
    procedure setEncounterData(date: TFMDateTime; patient: string);
  end;

var
  fraImm: TfraImm;

implementation

{$R *.dfm}
var
tempImm: string;

procedure TfraImm.btnExpandCollapseClick(Sender: TObject);
var
text: string;
begin
  inherited;
  text := '';
  if fCollapsed then
    begin
      if self.cboImm.ItemIndex > -1 then
        text := Piece(self.cboImm.Items.Strings[cboImm.ItemIndex], U, 2);
      if self.rgpDocumentation.ItemIndex > -1 then
        text := text + ' ' +  Copy(rgpDocumentation.Items.Strings[rgpDocumentation.ItemIndex], 2,
        Length(rgpDocumentation.Items.Strings[rgpDocumentation.ItemIndex]));
      if text <> '' then text := text + ' ' + 'Documentation';
    end;
   lblHeader.Caption := text;
end;

procedure TfraImm.cboImmClick(Sender: TObject);
var
tmp: string;
begin
  inherited;
  if cboImm.itemIndex = -1 then exit;
  tmp := cboImm.Items.Strings[cboImm.ItemIndex];
  selectPage(tmp, false, false);
end;

procedure TfraImm.clearFields;
begin
  if isEditing then
    begin
      cboImm.itemIndex := -1;
      cboImm.text := '';
      cboImm.Enabled := false;
      rgpDocumentation.ItemIndex := -1;
      isEditing := false;
      rgpDocumentation.Enabled := false;
    end;
end;

procedure TfraImm.collapse;
begin
  if not fCollapsed then btnExpandCollapseClick(self);
end;

constructor TfraImm.Create(aOwner: TComponent);
begin
  inherited;
  style := ssAbsolute;
  minValue := pnlWorkspace.Top + pnlWorkspace.Height;
  isEditing := false;
end;

procedure TfraImm.disableImmLookup;
begin
  cboImm.Enabled := false;
end;

procedure TfraImm.expand;
begin
  if fCollapsed then btnExpandCollapseClick(self);
end;

//get the edit frame control. Always the last row in the parent grid panel
function TfraImm.getEditControl: TControl;
var
grid: TGridPanel;
begin
    grid := TGridPanel(self.Parent);
    result := grid.ControlCollection.Controls[0, grid.RowCollection.Count - 1];
end;

//check per documenting an administration of an immunization if patient has an refusal or a
//contraindication on file
function TfraImm.performCheck(immunization, patient: string): integer;
var
warn, warn1: string;
begin
  // result = 0 no warning display, -1 user cancel the process, 1 user ok the warning continue the process
  result := 0;
  warn1 := 'Click Ok to continue or Cancel to Quit';
  if self.rgpDocumentation.ItemIndex = 0 then
    begin
      warn := checkForWarning(patient, immunization, self.adminDate);
      if warn <> '' then
        begin
          if messageDlg(warn + CRLF + CRLF + warn1, mtWarning, [mbOK, mbCancel], 0) = mrCancel then result := -1
          else result := 1;
        end;
    end;
end;

procedure TfraImm.rgpDocumentationClick(Sender: TObject);
var
tmpList: TStringList;
aControl: TControl;
idx: integer;
name, orgImm: string;
isDisable: boolean;
begin
  tmpList := TStringList.Create;
  try
    //prompt for warning when changing documentation status and in the middle of an edit process
    if isEditing and ((rgpDocumentation.Tag > -1) and  (rgpDocumentation.ItemIndex <> rgpDocumentation.Tag)) and
    (InfoBox('Currently editing a record. All data will be lost if you continue.' + CRLF + CRLF+
    'Click Yes to Continue.', 'WARNING', MB_YESNO) = IDNO) then
      begin
        rgpDocumentation.ItemIndex := rgpDocumentation.Tag;
        exit;
      end;
    isDisable := cboImm.Enabled = false;
    if rgpDocumentation.ItemIndex > -1 then cboImm.Enabled := true;
    if rgpDocumentation.Tag > -1 then
      begin
        aControl := getEditControl;
        TFraImmEdit(aControl).setPage(TFraImmEdit(aControl).pgBlank, 'blank', false, false)
      end;
    rgpDocumentation.Tag := rgpDocumentation.ItemIndex;
    if isDisable then orgImm := cboImm.Text;

    cboImm.ItemIndex := -1;
    cboImm.Text := '';
    cboImm.Items.Clear;
    if rgpDocumentation.ItemIndex = 0 then getShortActiveLookup(tmpList)
    else getShortHistoricalLookup(tmpList);
    FastAssign(tmpList, cboImm.Items);
    if isDisable then
      begin
        cboImm.Enabled := true;
        idx := cboImm.Items.IndexOf(orgImm);
        if idx > 0 then
          begin
            cboImm.ItemIndex := idx;
            cboImm.OnClick(cboImm);
            cboImm.Enabled := false;
          end;
      end;

    //tempIMM defined when calling the calling the frame with an immunization but no documentation
    //status
    if tempIMM <> '' then
      begin
        name := Piece(tempIMM, U, 2);
        idx := cboImm.items.indexOf(name);
        if idx = -1 then exit;
        cboImm.itemIndex := idx;
        cboImm.text := name;
        selectPage(cboImm.Items.Strings[idx], false, false);
      end;
  finally
    FreeAndNil(tmpList);
  end;
end;

procedure TfraImm.rgpDocumentationEnter(Sender: TObject);
begin
  inherited;
  rgpDocumentation.Tag := rgpDocumentation.ItemIndex;
end;

//called
procedure TfraImm.selectPage(immunization: string; details, edit: boolean);
var
aControl: TControl;
warn: integer;
needsOverride: boolean;
begin
  aControl := getEditControl;
  needsOverride := false;
  if details = true then
    begin
      TFraImmEdit(aControl).setPage(TFraImmEdit(aControl).pgDetails, immunization, edit, needsOverride);
      btnExpandCollapseClick(self);
      exit;
    end;
  isEditing := true;
  if (rgpDocumentation.ItemIndex = 0) and (cboImm.ItemIndex > -1)then
    begin
      warn := performCheck(cboImm.Items.Strings[cboImm.ItemIndex], self.patientIEN);
      if warn = -1 then exit
      else if warn = 1 then needsOverride := true;
  end;
  case rgpDocumentation.ItemIndex of
    0: TFraImmEdit(aControl).setPage(TFraImmEdit(aControl).pgAdmin, immunization, edit, needsOverride);
    1: TFraImmEdit(aControl).setPage(TFraImmEdit(aControl).pgHist, immunization, edit, needsOverride);
    2: TFraImmEdit(aControl).setPage(TFraImmEdit(aControl).pgContr, immunization, edit, needsOverride);
    3: TFraImmEdit(aControl).setPage(TFraImmEdit(aControl).pgRefuse, immunization, edit, needsOverride);
  end;
end;

//set initial edit values either from the grid or the main form
//for first time new immunization entry. Most likely have the immunization but not the
//documentation status
function TfraImm.setEditFields(immunization: string): boolean;
var
vid,name,documType: string;
idx: integer;
begin
  result := false;
  tempImm := '';
  vid := Piece(immunization, U, 1);
  name := Piece(immunization, U, 2);
  documType := Piece(immunization, u, 3);
  if name = genericIMM then
    begin
      if uVimmInputs.documentType = '0' then documType := 'Administered'
      else if uVimmInputs.documentType = '1' then documType := 'Historical'
    end;
  if documType = '' then
    begin
      tempImm := immunization;
      result := true;
      rgpDocumentation.Enabled := true;
      exit;
    end;
  idx := rgpDocumentation.Items.IndexOf('&' + documType);
  if idx = -1 then
    begin
      showMessage(documType + 'not found in the documenation Type list.');
      exit;
    end;
  rgpDocumentation.ItemIndex := idx;
  rgpDocumentationClick(rgpDocumentation);
  if name <> genericIMM then
    begin
      idx := cboImm.items.indexOf(name);
      if idx = -1 then
        begin
          showMessage(name + ' not found in the immunization list.');
          exit;
        end;
      cboImm.itemIndex := idx;
      cboImm.Enabled := false;
      result := true;
    end
    else
      begin
        cboImm.itemIndex := -1;
        cboImm.Enabled := true;
//        result := true;
      end;
end;

//procedure to set encounter data from the form
procedure TfraImm.setEncounterData(date: TFMDateTime; patient: string);
begin
  self.adminDate := date;
  self.patientIEN := patient;
  getIMMShortList(date);
end;

//edit process called form the immunization grid frame. Use when the grid is showing
procedure TfraImm.startEdits(immunization: string = ''; details: boolean = false; edit: boolean = true);
begin
  if self.fCollapsed then self.expand;
  rgpDocumentation.Enabled := true;
  if (immunization <> '') and (details = false) and (not setEditFields(immunization)) then exit;
  if immunization <> '' then selectPage(immunization, details, edit);
end;

//edit process called from the form. This is used when the the immunization grid does not show in the form
function TfraImm.startEditsFromMain(immunization: string; edit: boolean): boolean;
var
documentType: string;
begin
   result := true;
   documentType :=  Piece(immunization, U, 3);
    if documentType <> '' then
      begin
        documentType := Copy(self.rgpDocumentation.Items.Strings[StrToInt(documentType)], 2,
          Length(self.rgpDocumentation.Items.Strings[StrToInt(documentType)]));
        setPiece(immunization, U, 3, documentType);
      end;
   if not setEditFields(immunization) then
    begin
      result := false;
      exit;
    end;

    self.spBtnExpandCollapse.Visible := false;
    self.lblHeader.Left := 5;
    if cboImm.ItemIndex > -1 then
        begin
          self.lblHeader.Caption := Piece(self.cboImm.Items.Strings[self.cboImm.ItemIndex], U, 2) + ' ' + documentType + ' documentation';
          self.gridPanel.ColumnCollection.BeginUpdate;
          self.gridPanel.ColumnCollection[0].Value := 0;
          self.gridPanel.ColumnCollection[1].Value := 100;
          self.gridPanel.ColumnCollection.EndUpdate;
        end;
    selectPage(immunization, false, edit);
end;

end.
